*********************************************************
*							*
*	BSTAM INTERFACE FOR 8250 ON CCS Z80 CPU		*
*							*
*********************************************************
;
;	March 22, 1981
;
;	By	Bill Bolton
;		Software Tools
;		P.O. Box 80,
;		Newport Beach,
;		NSW, 2106
;		Australia
;
;
BASE	EQU     20H
STAT    EQU     BASE+5		;STATUS PORT
DATA    EQU     BASE		;DATA PORT
CR	EQU	0DH
LF	EQU	0AH
B300    EQU     384		;BAUD RATE DIVISORS FOR 8250'S
B600    EQU     192
B1200   EQU     96
B2400   EQU     48
B4800   EQU     24
B9600   EQU     12
BAUD	EQU	B300		;SELECTED BAUD RATE
;
	ORG	0103H
;
BEGIN:
INITIL:
	JMP     INITIU          ;UART/USART INITIALATION ENTRY POINT
INSPORT:
	JMP     INSPRU          ;STATUS PORT READ ENTRY POINT
ERRSET:	
	JMP     ERRSTU          ;UART/USART ERROR RESET ENTRY POINT
INPORT:
	JMP     INPRTU          ;READ DATA PORT ENTRY POINT
OUTPORT:
	JMP     OUPRTU 		;WRITE DATA PORT ENTRY POINT
;
;
INITIU:
	CALL	SIGNON
;
;
;ROUTINE TO INITIALIZE AN 8250
;REG HL HAS BAUD RATE WORD
;
        PUSH H
	PUSH D
	PUSH B
        LXI     H,BAUD		;GET BAUD RATE
IN8250:
	MVI	A,0FH		;SET DSR,CTS,CD
	OUT	BASE+4
	MVI	A,83H		;ENABLE DIVISOR ACCESS
	OUT	BASE+3
	MOV	A,L		;GET BAUD RATE DIVISOR, LOW
	OUT	BASE
	MOV	A,H		;GET BAUD RATE DIVISOR, HIGH
	OUT	BASE+1
	MVI	A,3		;DIABLE DIVISOR ACCESS AND SET
	OUT	BASE+3		; 8 BITS, 1 STOP, NO PARITY
	XRA	A
	OUT	BASE+1		;DIABLE INTERUPTS
	OUT	BASE+5		;RESET ERROR FLAGS
;
;THE FOLLOWING CODE USES THE BAUD RATE DIVISOR TO
;DO A TWO CHARACTER TIMES DELAY BEFORE RETURNING
;
        LXI	H,BAUD		;PUT BAUD RATE DIVISOR IN HL
        DAD     H		;MULT BY 16 TO GET DELAY
        DAD     H
        DAD     H
        DAD     H
LOOP1:
	DCX     H
        MOV     A,L
        ORA     H
        JNZ     LOOP1
        POP B
	POP D
	POP H
        RET
;
;       STATUS INPUT ROUTINE
;
INSPRU:
	PUSH	B
        IN      STAT		;RDA=BIT 0, TBE=BIT 5
	PUSH	PSW
        ANI     21H
        RLC      		;SHIFT RDA TO BIT 1
        MOV     B,A     	;SAVE FOR LATER
        RLC
        RLC			;TBE TO BIT 0
        ORA     B		;OR IN RDA
	MOV	B,A		;SAVE FOR LATER 
        POP     PSW       	;GET STATUS
	PUSH	PSW
	ANI	2		;MASK OUT OVERRUN ERROR
	RLC			;INTO BIT 2
	RLC			;BIT 3
	RLC			;BIT 4
	ORA	B		;MERGE WITH PREVIOUS 
	MOV	B,A		;SAVE FOR LATER
	POP	PSW		;GET STATUS
	PUSH	PSW
	ANI	8		;MASK OUT FRAMING ERROR
	RLC			;INTO BIT 4
	RLC			;BIT 5
	ORA	B		;MERGE WITH PREVIOUS
	MOV	B,A		;SAVE FOR LATER
	POP	PSW		;GET STATUS
	ANI	40H		;MASK OUT TX EMPTY
	RRC			;INTO BIT 5
	RRC			;BIT 4
	RRC			;BIT 3
	RRC			;BIT 2
	ORA	B		;MERGE WITH PREVIOUS
        ANI     37H       	;MASK WANTED BITS, DONT NEED BITS 3,6,7
	POP	B
        RET
ERRSTU:
        RET			;ONLY
;
INPRTU:
        IN	DATA		;GET DATA FROM PORT
        RET             	;RETURN TO BSTAM
;
OUPRTU:
        OUT	DATA		;SEND DATA TO REMOTE CPU
        RET			;RETURN TO BSTAM
;
;
MESSG:
	DB	CR,LF,LF
	DB	'Version For CCS CPU Card - March, 1981',CR,LF
	DB	'8250 Type UART at Ports 20H to 25H, no parity.',CR,LF,'$'
;
SIGNON:	PUSH	B
	PUSH	D
	PUSH	H
	LXI	D,MESSG
	MVI	C,9
	CALL	0005		;ANNOUNCE VERSION TO USER
	POP	H
	POP	D
	POP	B
	RET
;
	END	BEGIN
